/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.rsf;

import com.ibm.hwmca.base.managed.BaseTower;
import com.ibm.hwmca.base.rsf.handlers.RetainUtils;
import com.ibm.hwmca.base.rsf.requests.FormattedRequestData;
import com.ibm.hwmca.base.rsf.util.RsfHexadecimal;
import com.ibm.hwmca.base.settings.acctinfo.AccountInfo;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.p.rsf.EssStorageProblemAttributes;
import com.ibm.hwmca.xfw.rsf.RsfMachineInfo;
import com.ibm.hwmca.xfw.rsf.XFrameRsfRequestBody;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class EssStorageProblemRequestBody
extends XFrameRsfRequestBody
implements EssStorageProblemAttributes,
FormattedRequestData {
    private static final String TRACE_MASKT = "XRSFMM T";
    private static final String TRACE_MASKF = "XRSFMM F";
    private static final String TRACE_MASKD = "XRSFMM D";
    private static String blanks = "                                ";
    private static String EBCDIC = "Cp500";
    private static int neg = -256;
    private static final int MAXLINES = 102;
    private static byte[] nulls = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    private static String nullBytes = new String(nulls);
    private static char nullByte = nullBytes.charAt(0);
    private RsfMachineInfo failingMachInfo = null;
    private String customerName;
    private String customerPhone;

    public EssStorageProblemRequestBody() {
    }

    public EssStorageProblemRequestBody(PersistentData data) {
        super(((Persistent)data).parentData);
        this.failingMachInfo = ((Persistent)data).failingMachInfo;
        this.customerName = ((Persistent)data).customerName;
        this.customerPhone = ((Persistent)data).customerPhone;
    }

    public PersistentData getPersistentData() {
        Persistent result = new Persistent();
        result.parentData = super.getPersistentData();
        result.failingMachInfo = this.failingMachInfo;
        result.customerName = this.customerName;
        result.customerPhone = this.customerPhone;
        return result;
    }

    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        if (this.getAttribute("Reason") == null) {
            this.invalidMessage = "No reason specified in attribute list";
        } else if (this.getAttribute("Side") == null) {
            this.invalidMessage = "No side specified in attribute list";
        } else if (this.getAttribute("Severity") == null) {
            this.invalidMessage = "No severity specified in attribute list";
        } else if (this.getAttribute("Mode") == null) {
            this.invalidMessage = "No mode specified in attribute list";
        } else if (this.failingMachInfo == null) {
            this.invalidMessage = "Failing Machine has not been initialized";
        } else {
            this.getCustomerInfo();
            return true;
        }
        Trace.trace(TRACE_MASKF, "EssStorageProblemRequestBody.isValid: " + this.invalidMessage);
        return false;
    }

    public void setFailingDeviceInfo(RsfMachineInfo deviceInfo) {
        this.failingMachInfo = deviceInfo;
    }

    public RsfMachineInfo getFailingDeviceInfo() {
        return this.failingMachInfo;
    }

    public static String buildDataLines(String[] textLines) throws IllegalArgumentException {
        if (textLines.length > 102) {
            throw new IllegalArgumentException("Problem report notelog contains " + textLines.length + " lines.  Only 26*3+24 or less allowed.");
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < textLines.length) {
            int textLength = textLines[i].length();
            if (textLength > 72) {
                throw new IllegalArgumentException("Data text line, " + i + " greater than 72 characters long");
            }
            buffer.append(textLines[i]);
            buffer.append(blanks.substring(0, 72 - textLength));
            ++i;
        }
        String retval = buffer.toString();
        Trace.trace(TRACE_MASKD, "EssStorage buildDataLines: " + retval);
        return retval;
    }

    private static int getDataLength(String data) {
        if (data == null) {
            return 72;
        }
        int lastNonWhiteSpace = data.length() - 1;
        boolean foundNonWhiteSpace = false;
        while (lastNonWhiteSpace >= 0) {
            if (!Character.isWhitespace(data.charAt(lastNonWhiteSpace))) {
                foundNonWhiteSpace = true;
                break;
            }
            --lastNonWhiteSpace;
        }
        if (!foundNonWhiteSpace) {
            return 72;
        }
        int mod = lastNonWhiteSpace % 72;
        int retval = mod == 0 ? lastNonWhiteSpace : lastNonWhiteSpace + 72 - mod;
        Trace.trace(TRACE_MASKD, "EssStorage: data length=" + retval);
        return retval;
    }

    private void getCustomerInfo() {
        AccountInfo acctInfo = BaseTower.getBaseTower().getAccountSettings();
        this.customerName = acctInfo.getContact();
        this.customerPhone = acctInfo.getVoiceNumber();
        Date date = new Date();
        if (this.getAttribute("Date") == null) {
            this.putAttribute("Date", new SimpleDateFormat("dd/MM/yy").format(date));
        }
        if (this.getAttribute("Time") == null) {
            this.putAttribute("Time", new SimpleDateFormat("HH:mm:ss").format(date));
        }
    }

    public String buildData() {
        RsfMachineInfo mach = this.getReportingMachineInfo();
        StringBuffer data = new StringBuffer(blanks.substring(0, 31));
        String headerString = nullBytes.substring(0, 2) + "  ";
        data.append(nullBytes.substring(0, 2));
        data.append(headerString);
        data.append("02");
        data.append(headerString);
        data.append("01");
        data.append(headerString);
        data.append(RetainUtils.fixedLengthTextString(mach.getMachineType(), 4));
        data.append(headerString);
        data.append(RetainUtils.fixedLengthTextString(mach.getMachineModel(), 3));
        data.append(headerString);
        data.append(RetainUtils.fixedLengthTextString(mach.getMachineSerial(), 7));
        data.append(headerString);
        data.append(RetainUtils.fixedLengthTextString(this.failingMachInfo.getMachineType(), 4));
        data.append(headerString);
        data.append(RetainUtils.fixedLengthTextString(this.failingMachInfo.getMachineModel(), 3));
        data.append(headerString);
        data.append(RetainUtils.fixedLengthTextString(this.failingMachInfo.getMachineSerial(), 7));
        data.append(headerString);
        data.append(RetainUtils.fixedLengthTextString(this.customerName, 20));
        data.append(headerString);
        data.append("NOCLOSE");
        data.append(headerString);
        data.append("01");
        data.append(headerString);
        data.append(RetainUtils.fixedLengthTextString(this.getAttribute("Side"), 1));
        data.append(headerString);
        data.append(RetainUtils.fixedLengthTextString(this.getAttribute("Mode"), 4));
        data.append(headerString);
        data.append(RetainUtils.fixedLengthTextString(this.getAttribute("Date"), 8));
        data.append(headerString);
        data.append(RetainUtils.fixedLengthTextString(this.getAttribute("Time"), 8));
        data.append(headerString);
        data.append(RetainUtils.fixedLengthTextString(this.customerPhone, 19));
        data.append(headerString);
        data.append(RetainUtils.fixedLengthTextString(this.getAttribute("Reason"), 42));
        data.append(headerString);
        data.append(RetainUtils.fixedLengthString(this.getAttribute("Severity"), 2, false, '0'));
        String dataLines = this.getAttribute("Data");
        int totLength = EssStorageProblemRequestBody.getDataLength(dataLines);
        int dataLength = Math.min(dataLines.length(), 1728);
        dataLines = dataLines.substring(0, dataLength);
        try {
            data.append(new String(EssStorageProblemRequestBody.calcLength(totLength), EBCDIC));
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        data.append("  ");
        data.append(RetainUtils.fixedLengthTextString(dataLines, 1728));
        String stringData = data.toString();
        int printLength = stringData.length() - 1656;
        try {
            Trace.trace(TRACE_MASKD, "Data:\n" + RsfHexadecimal.buildHexadecimalString(stringData.getBytes(EBCDIC), 0, printLength) + "\n" + stringData.substring(0, printLength));
        }
        catch (Exception e) {}
        return stringData;
    }

    public String buildDataLineComfile(int number) {
        StringBuffer data = new StringBuffer(blanks.substring(0, 31));
        String headerString = nullBytes.substring(0, 2) + "  ";
        data.append(nullBytes.substring(0, 2));
        data.append(headerString);
        data.append(nullBytes.substring(0, 2));
        String dataLines = this.getAttribute("Data");
        int minIndex = (number - 2) * 1872 + 1728;
        int maxIndex = minIndex + 1872;
        int dataMax = Math.min(dataLines.length() - minIndex, maxIndex);
        dataLines = dataMax <= 0 ? "" : dataLines.substring(minIndex, dataMax + minIndex);
        try {
            data.append(new String(EssStorageProblemRequestBody.calcLength(EssStorageProblemRequestBody.getDataLength(dataLines)), EBCDIC));
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        data.append("  ");
        data.append(RetainUtils.fixedLengthTextString(dataLines, 1872));
        data.append(headerString);
        data.append(blanks.substring(0, 12));
        String retval = data.toString();
        try {
            Trace.trace(TRACE_MASKD, "EssStorageRequest send extra data:\n" + RsfHexadecimal.buildHexadecimalString(retval.getBytes(EBCDIC), 0, 50) + "\n" + retval.substring(0, 55));
        }
        catch (Exception e) {}
        return retval;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(super.toString());
        if (this.failingMachInfo != null) {
            buffer.append(this.failingMachInfo.toString());
        }
        return buffer.toString();
    }

    private static byte assignByte(int i) {
        if (i <= 127) {
            return (byte)i;
        }
        return (byte)(i | neg);
    }

    private static byte[] calcLength(int length) {
        byte[] byteLength = new byte[]{(byte)(length / 256), (byte)(length % 256)};
        return byteLength;
    }

    static {
        blanks = blanks + blanks + blanks + blanks + blanks + blanks;
    }

    private static class Persistent
    implements PersistentData {
        PersistentData parentData;
        RsfMachineInfo failingMachInfo;
        String customerName;
        String customerPhone;
        int version = 0;
        private static final long serialVersionUID = 1L;

        private Persistent() {
        }
    }
}

